require "TimedActions/ISBaseTimedAction"

TABAS_TubWaterActions = ISBaseTimedAction:derive("TABAS_TubWaterActions")

function TABAS_TubWaterActions:isValid()
    if not self.tfc_Base then return false end
    if self.tfc_Base:hasTfc() then
        if self.turnOn then
            if self.state == "empty" then
                return not self.tfc_Base:isEmpty()
            elseif self.state == "fill" then
                return not self.tfc_Base:isFull()
            end
        else
            return self.tfc_Base:isActivated(self.state)
        end
    end
    return false
end

function TABAS_TubWaterActions:waitToStart()
    if self.character:isAiming() then
        self.character:nullifyAiming()
    end
    if self.character:isSneaking() then
        self.character:setSneaking(false)
    end
    self.character:faceThisObject(self.tfc_Base.bathObject)
    return self.character:shouldBeTurning()
end

function TABAS_TubWaterActions:update()
end

function TABAS_TubWaterActions:start()
    self:setOverrideHandModels(nil, nil)
    local action
    if self.state == "fill" then
        action = "TABAS_TurnTap"
    elseif self.state == "empty" then
        if self.turnOn then
            action = "RemoveTubStopper"
        else
            action = "PutTubStopper"
        end
    end
    self:setActionAnim(action)
end


function TABAS_TubWaterActions:stop()
	ISBaseTimedAction.stop(self)
end

function TABAS_TubWaterActions:perform()
    self.tfc_Base:triggerActivate(self.state, self.turnOn)

	-- needed to remove from queue / start next.
	ISBaseTimedAction.perform(self)
end

function TABAS_TubWaterActions:adjustMaxTime(maxTime)
    return maxTime
end

function TABAS_TubWaterActions:new(character, tfc_Base, state, turnOn)
    local o = ISBaseTimedAction.new(self, character)
    o.tfc_Base = tfc_Base
    o.state = state
    o.turnOn = turnOn
    o.maxTime = 20

    o.ignoreHandsWounds = true
    o.useProgressBar = false
    o.caloriesModifier = 0
    return o
end